/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.table;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.table.TableCellEditor;

public class VWExpandButtonEditor
implements TableCellEditor,
ActionListener {
    protected EventListenerList listenerList = new EventListenerList();
    protected transient ChangeEvent changeEvent = null;
    protected JComponent editorComponent;
    protected int clickCountToStart = 0;
    Boolean m_currentValue;

    public VWExpandButtonEditor(JButton x) {
        x.setMargin(new Insets(0, 0, 0, 0));
        this.editorComponent = x;
        this.clickCountToStart = 1;
        ((JButton)this.editorComponent).addActionListener(this);
    }

    public Component getComponent() {
        return this.editorComponent;
    }

    public void setClickCountToStart(int count) {
        this.clickCountToStart = count;
    }

    public int getClickCountToStart() {
        return this.clickCountToStart;
    }

    public Object getCellEditorValue() {
        return this.m_currentValue;
    }

    public boolean isCellEditable(EventObject anEvent) {
        return !(anEvent instanceof MouseEvent) || ((MouseEvent)anEvent).getClickCount() >= this.clickCountToStart;
    }

    public boolean shouldSelectCell(EventObject anEvent) {
        boolean retValue = true;
        if (this.isCellEditable(anEvent) && (anEvent == null || ((MouseEvent)anEvent).getClickCount() >= this.clickCountToStart)) {
            retValue = this.startCellEditing(anEvent);
        }
        return retValue;
    }

    public boolean startCellEditing(EventObject anEvent) {
        ((JButton)this.editorComponent).doClick();
        return false;
    }

    public boolean stopCellEditing() {
        this.fireEditingStopped();
        return true;
    }

    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    public void addCellEditorListener(CellEditorListener l) {
        this.listenerList.add(CellEditorListener.class, l);
    }

    public void removeCellEditorListener(CellEditorListener l) {
        this.listenerList.remove(CellEditorListener.class, l);
    }

    protected void fireEditingStopped() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CellEditorListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((CellEditorListener)listeners[i + 1]).editingStopped(this.changeEvent);
        }
    }

    protected void fireEditingCanceled() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CellEditorListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((CellEditorListener)listeners[i + 1]).editingCanceled(this.changeEvent);
        }
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (value != null && value instanceof Boolean) {
            this.setValue(value);
        }
        return this.editorComponent;
    }

    public void setValue(Object x) {
        if (x != null && x instanceof Boolean) {
            this.m_currentValue = (Boolean)x;
        }
    }

    public void actionPerformed(ActionEvent e) {
        this.m_currentValue = this.m_currentValue != false ? new Boolean(false) : new Boolean(true);
        this.fireEditingStopped();
    }
}

